﻿var gShangLianLength = 0;
var gConst_AlertDiv = 'IndicatorDiv';
var gConst_hf_result_hp = 'hf_result_hp';
var gConst_hf_result_hp_locker = 'hf_result_hp_locker';
var gCosnt_hf_result_xl_locker = 'hf_locker';
var gConst_hf_curSelection = 'hf_curSelection';
var g_sLastQueryShanglian= 'hf_old_Shanglian';
var g_sLastQueryXialian= 'hf_old_Xialian';
var gConst_hf_cur_normal_select = "hf_cur_normal_select";
var gConst_hf_cur_adv_select = "hf_cur_adv_select";
var gConst_hf_cur_hp_select = "hf_cur_hp_select";
var gConst_hf_cur_IsNormal = "hf_cur_IsNormal";
var gConst_hf_cur_view = "hf_cur_view";
var gConst_hf_cur_normal_select = "hf_cur_normal_select"
var gConst_divSelectionView = 'divSelectionView';
var gConst_divCandView = 'divCandView';
var gConst_divIntro = 'divStep0';
var gConst_divXiaLianResults = 'divStep1';
var gConst_divHengPiResults = 'divStep2';
var gConst_div_hint = 'divHint';
var gConst_tbl_preview = 'preview';
var gConst_ShangLian = 'ShangLian';
var gConst_XiaLian = 'XiaLian';
var gConst_Hengpi = 'Hengpi';
var gConst_visible = 'visible';
var gConst_hidden = 'hidden';
var gConst_prefix_open = 'open';
var gConst_prefix_shut = 'shut';
var gConst_btn_showAdv = 'btn_showAdv';
var gConst_pic_update_disable = "update_disable";
var gConst_input_Hengpi = "inputHengpi";
var gConst_display_none = 'none';
var gConst_display_inline = '';
var g_sShanglian = "";
var g_sXialian = "";
var gConst_FontSize="16";

// Error Messages
var g_const_sErrorMsgNoXialianCandidate = "对不起，没有找到合适的下联候选。请您修改上联后再刷新候选，或者手工填写下联。";
var g_const_sErrorMsgNoHengpiCandidate = "对不起，没有找到和您的对联相匹配的横批候选。";
var g_const_sErrorMsgCompleteCouplet = "对不起，请您把上下联都完成后再题横批。";
var g_const_sErrorMsgCompleteXialianFirst = "对不起，请您先对下联，再题横批。";
var g_const_sErrorMsgInputShanglianFirst = "对不起，请在对下联之前填写上联。";
var g_const_sErrorMsgInputChineseString = "对不起，对联系统发现您的输入中包含了英文字符或标点（包括中文标点，如中文空格），请删除它们后重试一次。";
var g_const_sErrorMsgCannotRefreshXialianCandidate = "下联完成后将无法提供新的下联候选。如需新的候选，请点击并删除下联中不满意的字词，再点击“刷新候选”按钮。";
var g_const_sErrorMsgCompleteShanglianlianFirst = "对不起，请您先完成上联，再点击“刷新候选”按钮生成下联候选。";
var g_const_sErrorMsgHengpiCannotBeEmpty = "建议您给出四字横批。如果您不想要横批，请点击下方的“不要横批”。";
var g_const_sErrorMsgHengpiLengthInvalid = "对不起，请把四字横批填写完整。";
var g_const_sErrorMsgInvalidChineseString = "对不起，您的输入包含不恰当的词语。";
var g_const_sErrorMsgSystemBusy = "对不起，系统当前无法为您服务。";
var g_const_sErrorMsgNoAdvancedView = "对不起，系统无法为您当前的对联提供另一种选择方式。";
var g_const_sErrorMsgXialianNoChange = "对不起，请您修改部分对联再刷新结果，可以获得更新后的候选。";


var g_const_btnGetXialian = "ksdl_enable";
var g_const_hidValidHengpiLength = 'hf_valid_hp_length';
var g_const_btnShowCouplet = "show_enable";
var g_const_imgHelp = "imgHelp";

var gXLResult = null;
var gHPResult = null;


function pageLoad()
{
    //clear right panel
    var behavior = $find(accordionClientID);
    if (behavior) 
    {
        // Accordion selectedIndexChanged event handler
        behavior.remove_selectedIndexChanged(selectedIndexChanged);
        behavior.add_selectedIndexChanged(selectedIndexChanged);
        // Accordion selectedIndexChanging event handler
        behavior.remove_selectedIndexChanging(selectedIndexChanging);
        behavior.add_selectedIndexChanging(selectedIndexChanging);
        behavior.UseCustomiziedHeaderClickedHandler(coupletHeaderClickHandler);
        
    }
    if($get("hf_result_xl").value == "" || $get("hf_result_xl").value == null)
    {
        behavior.set_SelectedIndex(0);
    }
    else
    {
        //restore the view .
        /*--if show the final result in another page, the code below is not needed.--*/
        /*--from here--*/
        // Deserialize
        eval( "gXLResult = " + $get("hf_result_xl").value);
        $get(gConst_ShangLian).value = $get('hf_ShangLian').value;
        changeShanglianInputBackground();
        gShangLianLength = $get(gConst_ShangLian).value.length;
        var sXialian = replaceAll($get( gCosnt_hf_result_xl_locker ).value, '0', '');
        //$get( g_sLastQueryXialian ).value = sXialian;
        //reset result
	    var divXiaLianView = $find( gConst_divXiaLianResults );
	    //reset xialian
	    divXiaLianView.set_Xialian(sXialian);
	    //reset whole result and reset normal view in normal component.
	    //But the candidate view is not reseted in its set_reslut method. 
	    //So it need to be reseted below.
	    var context = new Utility.RequestContext($get( "hf_ShangLian" ).value, $get( gCosnt_hf_result_xl_locker ).value, "", true, "", "", "");
        divXiaLianView.set_result(gXLResult, context);
        //reset segment pattern
        divXiaLianView._adv.set_selectedID($get(gConst_hf_curSelection).value);
        divXiaLianView._adv.renderAdvView();
        divXiaLianView.set_Shanglian($get(gConst_ShangLian).value);        
        //reset input box of shanglian and xialian
        divXiaLianView.constructInput($get(gConst_ShangLian).value);
        //display the original view as user left the page.
        showORhide($get(gConst_hf_cur_IsNormal).value=="normal"? "Hide_Adv":"Show_Adv");
        var hp = $find(gConst_divHengPiResults);
        if($get(gConst_hf_result_hp).value != "" && $get(gConst_hf_result_hp).value != null)
        {
            // Deserialize
            eval( "gHPResult = " + $get(gConst_hf_result_hp).value);
	        hp.set_result(gHPResult);
	        hp.set_inputHengpi($get( gConst_hf_result_hp_locker ).value);
        }        
        //render preivew
        var preview = $find( gConst_tbl_preview );
        preview.set_lian(gConst_ShangLian, $get(gConst_ShangLian).value );
        preview.set_lian(gConst_XiaLian, sXialian);
        preview.set_hengpi($get( gConst_hf_result_hp_locker ).value);
        preview.GenerateLian();
        updateDynamicLian(0, sXialian, gConst_XiaLian, true);
        
        //reset the tag in normal viewgConst_hf_cur_hp_select
        var old_xialian_selectid = $get( gConst_hf_cur_normal_select ).value;
        divXiaLianView._normal.setSelectedCandidateId(old_xialian_selectid);
        
        //reset the tag in advanced view.
	    if($get("cand_tbody") == null) return;
        ResetAdvSelect(true);
	    
	    //reset the tag in hengpi view
        var old_hengpi_selectid = $get(gConst_hf_cur_hp_select).value;
        hp.setSelectedCandidateId(old_hengpi_selectid);

        var curstep = $get(gConst_hf_cur_view).value;
        ChangeLayer(curstep);
    }
    /*--to here--*/
}

/// <summary>
/// This method is to change the current display layer of accordion.
/// </summary>
/// <accessibility>public</accessibility>
/// <param name="index">Index of layer</param>
function ChangeLayer(index)
{
    var behavior = $find(accordionClientID);
    if (behavior) 
    {
        if(behavior.get_SelectedIndex() != index)
        {
            behavior.set_SelectedIndex(index);
        }
    }
}

/// <summary>
/// This method is to drop down select panel in advance view.
/// </summary>
/// <accessibility>public</accessibility>
/// <param name="obj">object of the element</param>
/// <param name="e">event</param>
function DropDownSelectPanel(obj, e)
{
    var adv = $find('divAdvView');
    
     if( null == gXLResult || 
            ( (null == gXLResult.XialianSystemGeneratedSets || gXLResult.XialianSystemGeneratedSets.length == 0) 
                && null == gXLResult.XialianWellKnownSets))
    {
        return;
    }
    var divADVCand = $get( gConst_divCandView );
    if($get( gConst_divSelectionView ).style.display == gConst_display_inline)
    {
        adv.set_selectpanel_display(false);
    }
    else
    {
        adv.set_selectpanel_display(true);
        var divXiaLianView = $find( gConst_divXiaLianResults );
        var selectedID = divXiaLianView._adv.get_selectedID();
        var table = $get("ot" + selectedID);
        table.style.backgroundColor = "#def4d4";
        table.style.color = "Black";
    }
    if (e.stopPropagation)
    {
        // FireFox
        e.stopPropagation();
    }
    else
    {
        // IE
        e.cancelBubble = true;
    }
}

/// <summary>
/// This method is to collapse the dropdown list of the different segment.
/// </summary>
/// <accessibility>public</accessibility>
/// <param name="e">event</param>
function HideSelectPanel(e)
{
    if (!e) var e = window.event;
    var sender = getSender(e);
    if($get( "ddBTN" )!=null )
    {
        if(sender.id=="ddBTN")
        {
            DropDownSelectPanel(sender,e);
        }
        else if(sender.id=="divHint")
        {
            
        }
        else
        {
            $get( "divSelectionView" ).style.display = gConst_display_none;
            $get( gConst_divCandView ).style.zIndex= '0';
            //confirm();
        }
    }
}

/// <summary>
/// This method is to replace all the occurence of 'find' with 'replace' in string 'str'
/// </summary>
/// <accessibility>public</accessibility>
/// <param name="str">the original string</param> 
/// <param name="find">the string need to be changed</param> 
/// <param name="replace">replace string</param> 
/// <return value>If success, it will return the new string which is replaced all the occurence of 'find' with 'replace' in string 'str'</return value>
function replaceAll( str, find, replace )
{
	var idx = str.indexOf( find );

	while ( idx > -1 )
	{
		str = str.replace( find, replace );
		idx = str.indexOf( find );
	}

	return str;
}

/// <summary>
/// If there are more than one segmentation pattern in the returned result.
/// We will show the different word candidate matrix separately according to the user's selection.
/// </summary>
/// <accessibility>public</accessibility>
/// <param name="selectedID">selected segment index of the candidate view</param> 
function ShowWordCandidate( selectedID )
{
    
    //get candidate view according to selected index. The default value of gConst_hf_curSelection field is 0.
    // If user has not select index which means this is the original XiaLian for the given
	// ShangLian, then we will show the first segment pattern then.
	var adv = $find('divAdvView');
	var selectID=$get(gConst_hf_curSelection).value;
	adv.set_selectedID(selectID);

}

/// <summary>
/// This method is to merge the content of the TD into a word.
///e.g. <td><input type="text" value="明"><input type="text" value="天"></td>
///after merging the result is "明天"
/// </summary>
/// <accessibility>public</accessibility>
/// <param name="cell">TD contain some input box</param> 
/// <return value>If success, it will return the new string after merging</return value>
function mergeCell(cell)
{
    var text = "";
    for(i = 0; i<cell.childNodes.length; i++)
    {
        text += cell.childNodes[i].value;
    }
    return text;
}


/// <summary>
/// This is executed when user click a result of either normal view or word candidate view.
/// This is going to refill the dynamic XiaLian cell accordingly.
/// </summary>
/// <accessibility>public</accessibility>
/// <param name="startIdx">start index of the string which need to be update.</param> 
/// <param name="content">replacing string</param> 
/// <param name="ShangLianORXiaLian">a flag indicate this is shanglian or xialian</param> 
/// <param name="IsNormal">a flag indicate whether the current view is normal view</param> 
function updateDynamicLian( startIdx, content, ShangLianORXiaLian, IsNormal )
{
	var nCurIdx = parseInt( startIdx );
	var nContentLength = content.length;
    var divXialian = $find(gConst_divXiaLianResults);
    
	for ( var i = 0; i < nContentLength && i < gShangLianLength; i++ )
	{
		//change normal selected item.
        divXialian._normal.setNormalSelectedByID ( nCurIdx + i , ShangLianORXiaLian, content.charAt( i ));
		
		//change advanced selected item.
		divXialian._adv.setADVSelectedByID ( nCurIdx + i , ShangLianORXiaLian, content.charAt( i ));

		//change preview 
	    var preview = $find(gConst_tbl_preview);
	    if( ShangLianORXiaLian == gConst_ShangLian)
	    {
	        preview.updateShangLian( startIdx, content );
	    }
	    else
	    {
	        preview.updateXiaLian( startIdx, content );
	    }
	}
}


/// <summary>
/// This method is to check to see if all the shanglian or xialian cells are fill with char.
/// </summary>
/// <accessibility>public</accessibility>
/// <param name="lian">a flag indicate this is shanglian or xialian</param> 
/// <return value>If shanglian/xialian is completeness, return true
/// Otherwise, return false.</return value>
function CheckDynamicCellsCompleteness( lian )
{
	var fComplete = true;

	var preview = $find( gConst_tbl_preview );
	for ( var i = 0; i < gShangLianLength; i++ )
	{
		var word;
		if(lian == gConst_ShangLian)
        {

            word = preview.get_shanglian_word(i);
        }
        else
        {
            word = preview.get_xialian_word(i);
        }
		
		if ( !checkIsChinese( word ))
		{
			fComplete = false;
			break;
		}
	}
	return gShangLianLength == 0 ? false : fComplete;
}

/// <summary>
/// This method is to get current Hengpi length and check it if its length is valid.
/// </summary>
/// <accessibility>public</accessibility>
/// <return value>If hengpi is completeness, return true
/// Otherwise, return false.</return value>
function CheckHengPiCompleteness()
{
    var hp = $find(gConst_divHengPiResults);
    var iHengpiLength = hp.get_inputHengpi().length;
    if(iHengpiLength == 0 || iHengpiLength == 4)
    {
        return true;
    }
    else
    {
        return false;
    }
}

/// <summary>
/// This method is to check if all the XiaLian input cell has been fill with chinese char.
/// If this is true, we will change the button text to 'diplay coulets'.
/// </summary>
/// <accessibility>public</accessibility>
/// <return value>If both shanglian and xialian are all completeness, return true.
/// Otherwise, return false.</return value>
function CheckLianComplete()
{
	if ( CheckDynamicCellsCompleteness(gConst_XiaLian) 
	    && CheckDynamicCellsCompleteness(gConst_ShangLian))
	{
        return true;
	}
	else
	{
	    return false;
	}
	
}

/// <summary>
/// when the shanglian input box is empty, change the background picture.
/// otherwise, show the background picture “上联最多十字”.
/// </summary>
/// <accessibility>public</accessibility>
function changeShanglianInputBackground()
{
    if($get(gConst_ShangLian).value.length==0)
    {
        $get( gConst_ShangLian ).className = "ShangLian_original";     
    }
    else
    {
        $get( gConst_ShangLian ).className = "ShangLian";
    }
    return false;
}

/// <summary>
/// when the shanglian input box is focus, change the background picture.
/// when the shanglian input box is blur, show the background picture “上联最多十字”.
/// </summary>
/// <accessibility>public</accessibility>
function onFocusShanglianInput()
{
    $get( gConst_ShangLian ).className = "ShangLian";
}

/// <summary>
/// This function handle the onkeydown event for the body.
/// WhiteSpace and Esc is filtered out here.
/// Backspace   |   8
/// Enter       |   13
/// </summary>
/// <accessibility>public</accessibility>
/// <param name="evt">event</param>
function OnBodyKeyDown(evt)
{
    evt = evt ? evt : (window.event ? window.event : null);
    var sender = getSender(evt);
    if( sender.id == gConst_ShangLian || sender.id == gConst_input_Hengpi)
    {
        return;
    }
    //if backspace, prevent the default event.
    if ( evt.keyCode == 8 )
    {
        if(evt.preventDefault)  
        {
            evt.preventDefault();
        }
        else
        {
            evt.returnValue = false; 
        }
    } 
    //if enter, hide the hint box and get xialian, if necessary.
    else if ( evt.keyCode == 13 )
	{
	    var hint = $find( gConst_div_hint );
	    if($get(gConst_div_hint).style.display == gConst_display_inline)
	    {
	    	hint.set_display(false);
	    }
	    else if($get(gConst_hf_cur_view).value == "1")
	    {
	        AJAXGetXiaLian(evt);
	    }	    
	} 
}

/// <summary>
/// This function handle the onkeydown event for ShangLian input cell.
/// WhiteSpace and Esc is filtered out here.
/// Whitespace   |   32
/// Esc          |   27
/// </summary>
/// <accessibility>public</accessibility>
/// <param name="evt">event</param>
function filterKeyStroke(evt)
{
    evt = evt ? evt : (window.event ? window.event : null);

	if ( evt.keyCode == 32 || evt.keyCode == 27 )
	{
		if(evt.preventDefault)  evt.preventDefault();
        else evt.returnValue = false;
	}
	else if ( evt.keyCode == 13 )
	{
		if($get(gConst_div_hint).style.display == "")
	    {
	        confirm();
	        return;
	    }
		onGetXialianClicked();
		if(evt.preventDefault)  evt.preventDefault();
        else evt.returnValue = false;
        
        if (evt.stopPropagation)
        {
            // FireFox
            evt.stopPropagation();
        }
        else
        {
            // IE
            evt.cancelBubble = true;
        }
	}
	else
	{
		evt.returnValue = true;
	}
	//changeBtn();
}

/// <summary>
/// This function handle the onkeydown event for ShangLian/XiaLian input cell.
/// This is mainly deal with the special key stroke within the input cell, such as
/// KeyName      |   KeyCode
/// Whitespace   |   32
/// Esc          |   27
/// Backspace    |   8
/// Del          |   46 or 127
/// Left arrow   |   37
/// Right arrow  |   39          |   27
/// </summary>
/// <accessibility>public</accessibility>
/// <param name="dynCell">object contain shanglian/xialian input box</param>
/// <param name="Lian">a flag indicate this is shanglian or xialian</param>
/// <param name="evt">event</param>
function filterDynamicKeyDown( dynCell, Lian, evt )
{
    evt = evt ? evt : (window.event ? window.event : null);
    var inputID = dynCell.id.slice( dynCell.id.length - 1 );
    var prefix = dynCell.id.substring(0, dynCell.id.length - 1);
	var curIndex = parseInt( inputID );
	var divXiaLianView = $find(gConst_divXiaLianResults);
	var preview = $find(gConst_tbl_preview);
	
	// escape whitespace and ecs key
	if ( evt.keyCode == 32 || evt.keyCode == 27 )
	{
		if(evt.preventDefault)  evt.preventDefault();
        else evt.returnValue = false;
	}
	// backspace pressed
	else if ( evt.keyCode == 8 )
	{
		if ( $get( prefix + curIndex ).value == "" )
		{
		    if ( curIndex > 0 )
		    {
			    var iLeftNeighbourIndex = parseInt(curIndex - 1);
			    $get( prefix + iLeftNeighbourIndex ).focus();
			    $get( prefix + iLeftNeighbourIndex ).value == "";
			    divXiaLianView._normal.setNormalSelectedByID(iLeftNeighbourIndex,Lian,"");
                divXiaLianView._adv.setADVSelectedByID(iLeftNeighbourIndex,Lian,""); 
    		                 
                //delete the content of preview cell
                if(Lian == gConst_ShangLian)
                {
	                preview.clear_shanglian_word(iLeftNeighbourIndex);
	            }
	            else
	            {
	                preview.clear_xialian_word(iLeftNeighbourIndex);
	            }
		    }

			if(evt.preventDefault)  evt.preventDefault();
            else evt.returnValue = false;
		}
		else
		{
            divXiaLianView._normal.setNormalSelectedByID(curIndex,Lian,"");
            divXiaLianView._adv.setADVSelectedByID(curIndex,Lian,""); 
		                 
            //delete the content of preview cell
            if(Lian == gConst_ShangLian)
            {
	            preview.clear_shanglian_word(curIndex);
	        }
	        else
	        {
	            preview.clear_xialian_word(curIndex);
	        }
		}
	}
	// Del pressed
	else if ( evt.keyCode == 127)
	{
		if ( $get( prefix + curIndex ).value == "" )
		{
		    if ( curIndex < gShangLianLength - 1 )
		    {
			    var iRightNeighbourIndex = parseInt(curIndex + 1);
			    $get( prefix + iRightNeighbourIndex ).focus();
			    $get( prefix + iRightNeighbourIndex ).value == "";
			    
			    divXiaLianView._normal.setNormalSelectedByID(iRightNeighbourIndex,Lian,"");
                divXiaLianView._adv.setADVSelectedByID(iRightNeighbourIndex,Lian,""); 
    		                 
                //delete the content of preview cell
                if(Lian == gConst_ShangLian)
                {
	                preview.clear_shanglian_word(iRightNeighbourIndex);
	            }
	            else
	            {
	                preview.clear_xialian_word(iRightNeighbourIndex);
	            }
		    }

			if(evt.preventDefault)  evt.preventDefault();
            else evt.returnValue = false;
		}
		else
		{ 
		        
		    divXiaLianView._normal.setNormalSelectedByID(curIndex,Lian,"");
            divXiaLianView._adv.setADVSelectedByID(curIndex,Lian,""); 
		                 
            //delete the content of preview cell
            var preview = $find(gConst_tbl_preview);
            if(Lian == gConst_ShangLian)
            {
	            preview.clear_shanglian_word(curIndex);
	        }
	        else
	        {
	            preview.clear_xialian_word(curIndex);
	        }
		}
	}
}

// This function handle the onkeyup event for XiaLian/XiaLian input cell.
// This is mainly deal with the special key stroke within the input cell, such as
// KeyName      |   KeyCode
// Whitespace   |   32
// Esc          |   27
// Backspace    |   8
// Del          |   46
// Left arrow   |   37
// Right arrow  |   39
//do not support the left arrow and right arrow
//because of the conflict with the chinese input method.
function filterDynamicKeyUp(dynCell, Lian, evt)
{
//    evt = evt ? evt : (window.event ? window.event : null);
//    //alert(evt.keyCode);
//    var inputID = dynCell.id.slice( dynCell.id.length - 1 );
//    var prefix = dynCell.id.substring(0, dynCell.id.length - 1);
//	var curIndex = parseInt( inputID );
//	
//	// Left arrow pressed    
//	if ( evt.keyCode == 37 )//|| evt.keyCode == 38 )
//	{
//		if ( curIndex > 0 )
//		{
//			$get( prefix + ( curIndex - 1 ) ).focus();
//		}
//	}
//	// Right arrow pressed
//	else if ( evt.keyCode == 39 )//|| evt.keyCode == 40 )
//	{
//		if ( curIndex < gShangLianLength - 1 )
//		{
//			$get( prefix + ( curIndex + 1 ) ).focus();
//		}
//	}
}

/// <summary>
/// This is useful if we turn off the maxLength="1" attribute of <INPUT> tag of XiaLian.
/// This allow user to input consecutive lock information instead of assign them one by one
/// into each cell.
/// This is the event handler for onblur and onKeyUp event for XiaLian input cell.
/// </summary>
/// <accessibility>public</accessibility>
/// <param name="dynCell">object contain shanglian/xialian input box</param>
function handleLianTextChange( dynCell )
{
	// Get input string from current cell
	var curString = dynCell.value;

	// Get index for current input cell
	var inputID = dynCell.id.slice( dynCell.id.length-1 );
	
	var lian = dynCell.id.slice(3, dynCell.id.length-1);
	var prefix = dynCell.id.substring(0, dynCell.id.length - 1);

	// Assign the input string to the current and following cell until reach the end of up limit.
	var nCurInputLength = curString.length;

    var preview = $find( gConst_tbl_preview );
    
	//currently, the lenth of the dynCell.value is not more than 1.
	if ( dynCell.value.length > 1 )
	{
		for (var iCurrentIndex = inputID; iCurrentIndex < gShangLianLength && iCurrentIndex - inputID < nCurInputLength; iCurrentIndex++ )
		{	    
			if(lian == gConst_ShangLian)
            {
                $get( prefix + iCurrentIndex).value = curString.charAt( iCurrentIndex - inputID );
                preview.updateShangLian(iCurrentIndex, curString.charAt( iCurrentIndex - inputID ));
            }
            else
            {
                //$get( prefix + iCurrentIndex).value = curString.charAt( iCurrentIndex - inputID );
                //preview.updateXiaLian(iCurrentIndex, curString.charAt( iCurrentIndex - inputID ));
            }
            if(parseInt(iCurrentIndex + 1) < gShangLianLength)
            {
                //$get( prefix + parseInt(iCurrentIndex + 1)).focus();
            }
		}
	}
	else
	{
        if(lian == gConst_ShangLian)
        {

            preview.updateShangLian(inputID, curString);
        }
        else
        {
            preview.updateXiaLian(inputID, curString);
        }

	}
	
	$get('hf_ShangLian').value = GetDynamicLianString(gConst_ShangLian);
	$get(gCosnt_hf_result_xl_locker).value = GetDynamicLianString(gConst_XiaLian);
}

/// <summary>
/// This function is executed when user click button to submit request for getting XiaLian results.
/// We store the ShangLian information and lock information in XiaLian to hidden field separately.
/// E.g. Store "海阔凭鱼跃" as ShangLian into hf_ShangLian server control;
///      Store '00000' as lock information for XiaLian into hf_locker server control.
/// </summary>
/// <accessibility>public</accessibility>
function onGetXiaLianRequestArguments()
{
	var strShangLian = "";
	var strXiaLian = "";
    var strBgStyle=""; 
     
	// Compose lock information for XiaLian

	for ( i = 0; i < gShangLianLength; i++ )
	{

		var preview = $find(gConst_tbl_preview);
		var textSL = preview.get_shanglian_word(i);
		var textXL = preview.get_xialian_word(i);

	    // Get ShangLian Info

		if ( textSL != "" )
		{
			strShangLian += textSL;
		}
		else
		{
			strShangLian += '0';
		}

    	// Get XiaLian Info

		if ( textXL != "" )
		{
			strXiaLian += textXL;
		}
		else
		{
			strXiaLian += '0';
		}

	}
    
	// Store arguments to hidden field before send AJAX request
	$get( gCosnt_hf_result_xl_locker ).value = strXiaLian;
	$get( "hf_ShangLian" ).value = strShangLian;
	
	var preview = $find(gConst_tbl_preview);
	if($get( gConst_Hengpi ) != null)
	{
	    $get( gConst_hf_result_hp_locker ).value = preview.get_hengpi();
	}
}

/// <summary>
/// This enable the switch between normal view and Adv view.
/// </summary>
/// <accessibility>public</accessibility>
/// <param name="obj">object</param>
function onShowAdv(obj)
{
    showORhide(obj.id);
}

/// <summary>
/// This enable the switch between normal view and Adv view.
/// </summary>
/// <accessibility>public</accessibility>
/// <param name="id">a flag indicate normal view or advanced view</param>
function showORhide(id)
{
    var divXiaLianView = $find( gConst_divXiaLianResults );
	if ( id == "Hide_Adv" )//show normal view
	{
		divXiaLianView.set_Normal(true);
		divXiaLianView._adv.set_selectedID(divXiaLianView._adv.get_selectedID());
		$get(gConst_hf_cur_IsNormal).value = "normal";
	}
	else if ( id == "Show_Adv" )//show adv view
	{
        if(null == gXLResult)
        {
            ShowCoupletErrorMsg(0, $get(g_const_imgHelp), g_const_sErrorMsgNoXialianCandidate, -365, 135);
            return;
        }
        
        if(null == gXLResult.XialianSystemGeneratedSets)
        {
            ShowCoupletErrorMsg(0, $get(g_const_imgHelp), g_const_sErrorMsgNoAdvancedView, -365, 135);
            return;
        }
        
        divXiaLianView.set_Normal(false);
        $get(gConst_hf_cur_IsNormal).value = "adv";
        
        
        //After the xialian advanced view rendered again,user selection may be changed
        //If clicking on normal view affect the advanced view, it need not to reset user's choice.
        //Otherwise, reset user's chioce.
        //if the original shanglian is "海阔凭鱼跃", it need to loop for 3 times to reset the user choice.
	    if(!divXiaLianView._adv.get_segmentPatternChanged())
	    {
            //redraw the user choice.
            ResetAdvSelect(true);
        }
        else
        {
            //because of clicking the normal candidate maybe affect the segment pattern
            //Here render the advance view again is necessary.
            divXiaLianView._adv.renderAdvView();
        }
	}
}

/// <summary>
/// This method is to reset the selected indicator on advanced view.
/// </summary>
/// <accessibility>public</accessibility>
/// <param name="flag">a flag indicate the inputbox should be checked or unchecked.</param>
function ResetAdvSelect(flag)
{
    if(null == gXLResult)
    {
        return;
    }
    for( var i = 0 ;i<gXLResult.XialianSystemGeneratedSets[ $get(gConst_hf_curSelection).value ].SegmentPattern.split('/').length-1; i++)
    {
        var row = $get( gConst_hf_cur_adv_select ).value.charAt(i);
        if( row == "*" ) continue;
        //because of the space row, double the row to make it the real row
        var td = $get("cand_tbody").childNodes[row*2].childNodes[i];
        var selectText = mergeCell(td);
        for(var j = 0; j<selectText.length; j++)
        {
            if(flag)
            {
                td.childNodes[j].className = "advCheck";
            }
            else
            {
                 td.childNodes[j].className = "advUncheck";   
            }
        }
    }
}

/// <summary>
/// This method is to display normal view or advance view according to $get( gConst_btn_showAdv ).value.
/// </summary>
/// <accessibility>public</accessibility>
/// <param name="flag">a flag indicate normal view or advanced view.</param>
function set_normal_adv_display(isNormal)
{
    var divXiaLianView = $find( gConst_divXiaLianResults );
    var normal = divXiaLianView._normal;
    var adv = divXiaLianView._adv;
   
   if(isNormal) 
   {
        normal.set_display(true);
        adv.set_display(false);
   }
   else
   {
        normal.set_display(false);
        adv.set_display(true);
   }   
}

/// <summary>
/// This method is to get the element who invoked current evnet.
/// </summary>
/// <accessibility>private</accessibility>
/// <param name="evt">event object</param>
/// <return value>If success, it will return DOM element</return value>
function getSender(event)
{
    var target = event.target;              // DOM standard event model
    if (!target)
    {
        target = event.srcElement;          // IE event model
    }
    
    return target;
}

/// <summary>
/// Event handler for ShangLian confirm button in step 1.
/// </summary>
/// <accessibility>public</accessibility>
function onGetXialianClicked()
{
    var old_shanglian_length = gShangLianLength;
    gShangLianLength = $get( gConst_ShangLian ).value.length;
    $get( "hf_ShangLian" ).value = $get( gConst_ShangLian ).value;
    var context = new Utility.RequestContext($get(gConst_ShangLian).value, "", "", "", 0, 1, null);
    IsValidChineseString($get(gConst_ShangLian).value, context);    
}

/// <summary>
/// Event handler for ShangLian confirm button in step 2.
/// </summary>
/// <accessibility>public</accessibility>
function onGetHengpiClicked()
{
    if(CheckLianComplete())
    {
        var currentShanglian = GetDynamicLianString(gConst_ShangLian);
        var currentXialian = GetDynamicLianString(gConst_XiaLian);
        var context = new Utility.RequestContext(currentShanglian, currentXialian, "", "", 1, 2, false);
                IsValidChineseString(currentShanglian, context);
    }
    else
    {
        ShowCoupletErrorMsg(0, $get(g_const_imgHelp), g_const_sErrorMsgCompleteCouplet, -365, 135);
    }
}

/// <summary>
/// This method is to expand or collapse different right panel according to selected index.
/// </summary>
/// <accessibility>public</accessibility>
function selectedIndexChanged(sender, evtArg)
{
    var newIndex = evtArg.get_selectedIndex();
    //$get( gConst_hf_curView ).value = newIndex;
    //maybe user change shangliang,but he does not click '��确认上?
    //so we have to reset shanglian input box.
    if(newIndex==0)
    {
        update_shanglian_inputbox();
    }
    //change the picture of title 
    for(var i=0;i<3;i++)
    {
        $get( gConst_prefix_shut + i ).style.display = gConst_display_inline;
        $get( gConst_prefix_open + i ).style.display = gConst_display_none;
    }
    $get( gConst_prefix_shut + newIndex ).style.display = gConst_display_none;
    $get( gConst_prefix_open + newIndex ).style.display = gConst_display_inline;
}


/// <summary>
/// This method is to update shanglian input box in step0.
/// </summary>
/// <accessibility>public</accessibility>
function update_shanglian_inputbox()
{    
    var tmp="";
    var cell="";
    var complete = true;
    var preview = $find( gConst_tbl_preview );
    for( i=0; i<gShangLianLength; i++)
    {
        cell = preview.get_shanglian_word(i);

        if(checkIsChinese(cell))
        {
            tmp += cell;
        }
        else
        {
            complete = false;
            break;
        }
    }
    if(complete)
    {
        $get( gConst_ShangLian ).value = tmp;
    }
}

/// <summary>
/// This method is to check shanglian contains non-chinese.
/// </summary>
/// <accessibility>private</accessibility>
/// <return value>If shanglian is empty, return "empty".
///               If shanglian contains non-chinese string, return "notChinese".
///               Otherwise, return "valid".</return value>
function check_shanglian_inputbox()
{
    var length = $get( gConst_ShangLian ).value.length;
    if(length == 0) return "empty";
    var oneword="";
    var valid = "valid";
    for(var i=0; i<length; i++)
    {
        oneword = $get( gConst_ShangLian ).value.charAt(i);
        if(!checkIsChinese(oneword))
        {
            valid = "notChinese";
            break;
        }
    }
    return valid;
}

/// <summary>
/// if the char is a chinese, return true. otherwise false.
/// we ignore chinese SBC case ,that is [\uFE30-\uFFA0] 
/// [\u4E00-\u9FA5] means the normal chinese character in unicode
/// param "gi" means globle search and ignore match case
/// </summary>
/// <accessibility>private</accessibility>
/// <return value>If shanglian contains non-chinese string, return false.
///               Otherwise, return true.</return value>
function checkIsChinese(str)   
{      
    if(str == "") 
    {  
        return false;  
    } 
    var pattern = new RegExp("^([\u4E00-\u9FA5])*$","gi"); 
  
    return pattern.test(str) ? true : false;
  
}

/// <summary>
/// This method is to merge shanglians/xialians cell into a sentence.
/// </summary>
/// <accessibility>private</accessibility>
/// <param name="lian">a flag indicate this is shanglian or xialian</param>
/// <return value>whole sentence of shanglian/xialian</return value>
function GetDynamicLianString( lian )
{
    var lianresult="";
    for( i=0; i<gShangLianLength; i++)
    {
        
        var preview = $find( gConst_tbl_preview );

		var word;
		if(lian == gConst_ShangLian)
        {

            word = preview.get_shanglian_word(i);
        }
        else
        {
            word = preview.get_xialian_word(i);
        }  
        
        if(word == "")
        {
            lianresult += " ";
        }
        else
        {
            lianresult += word;          
        }
    }
    return lianresult;
}

/// <summary>
/// event handler when the header of the accordion is clicked.
/// </summary>
/// <accessibility>private</accessibility>
/// <param name="evt">event</param>
function coupletHeaderClickHandler(evt)
{   
    // Get the header that raised the event (by walking up the event target's
    // control hierarchy until we find an element just below the root of the accordion)
    var header = evt.target;
    var accordion = this.get_element();
    while (header && (header.parentNode !== accordion)) 
    {
        header = header.parentNode;
    }
    
    // Stop the event from bubbling out of the header pane and prevent any
    // action from happening unless we clicked a control inside the header
    evt.stopPropagation();
    if (this._suppressHeaderPostbacks) 
    {
        evt.preventDefault();
    }
    
    // Select this pane (which saves it to ClientState and initiates an animation
    // to show the content pane).  If the user clicked the currently open pane and
    // we're not required to keep one pane open, then we'll set the selected index
    // to -1 which will close it (which means all panes will be collapsed).
    var index = header._index;
    if ((index === this._selectedIndex) && !this._requireOpenedPane) {
        index = -1;
    }
    
    gShangLianLength = $get( gConst_ShangLian ).value.length;
    $get( "hf_ShangLian" ).value = $get( gConst_ShangLian ).value;
    
    var oldSelectedIndex = this._selectedIndex;
    var newSelectedIndex = index;
        
    if(newSelectedIndex < oldSelectedIndex)
    {
        this._changeSelectedIndex(index, true);
    }
    else if(newSelectedIndex > oldSelectedIndex)
    {
        if(oldSelectedIndex == 0)
        {
            if(newSelectedIndex == 1)
            {
                // from step 0 to 1
                var context = new Utility.RequestContext($get(gConst_ShangLian).value, "", "", "", 0, 1, evt);
                IsValidChineseString($get(gConst_ShangLian).value, context);
            }
            else if(newSelectedIndex == 2)
            {
                // from step 0 to 2
                var isValid = check_shanglian_inputbox();
                if( isValid == "valid")
                {
                    // if the shanglian text change, user cannot go directly to step 2
                    if($get(gConst_ShangLian).value != GetDynamicLianString(gConst_ShangLian))
                    {
                        ShowCoupletErrorMsg(0, $get(g_const_imgHelp), g_const_sErrorMsgCompleteXialianFirst, -365, 105);
                    }
                    else
                    {
                        // no change in shanglian text
                        // CheckLianComplete() return true if completeness
                        if(CheckLianComplete())
                        {
                            var currentShanglian = GetDynamicLianString(gConst_ShangLian);
                            var currentXialian = GetDynamicLianString(gConst_XiaLian);
                            var context = new Utility.RequestContext(currentShanglian, currentXialian, "", "", 0, 2, false);
                            IsValidChineseString(currentShanglian, context);
                        
                        }
                        else
                        {
                            if(gShangLianLength == 0)
                            {
                                // xcui: It seems that code cannot goes here.
                                ShowCoupletErrorMsg(0, $get(g_const_imgHelp), g_const_sErrorMsgInputShanglianFirst, -365, 105);
                            }
                            else
                            {
                                ShowCoupletErrorMsg(0, $get(g_const_imgHelp), g_const_sErrorMsgCompleteXialianFirst, -365, 105);
                            }
                        }
                    }
                }
                else if(isValid == "empty")
                {
                    ShowCoupletErrorMsg(0, $get(g_const_imgHelp), g_const_sErrorMsgInputShanglianFirst, -365, 105);
                }
                else
                {
                    ShowCoupletErrorMsg(0, $get(g_const_imgHelp), g_const_sErrorMsgInputChineseString, -365, 105);
                }
            }
        }
        else
        {
            // from step 1 to 2
            if(CheckLianComplete())
            {
                var currentShanglian = GetDynamicLianString(gConst_ShangLian);
                var currentXialian = GetDynamicLianString(gConst_XiaLian);
                var context = new Utility.RequestContext(currentShanglian, currentXialian, "", "", 1, 2, false);
                IsValidChineseString(currentShanglian, context);
            }
            else
            {
                ShowCoupletErrorMsg(0,  $get(g_const_imgHelp), g_const_sErrorMsgCompleteCouplet, -365, 135);
            }
            
        }
        
    }
}

/// <summary>
/// event handler when the accordion panel changing. And record the current step.
/// </summary>
/// <accessibility>private</accessibility>
/// <param name="sender">element object</param>
/// <param name="evtArg">event argument</param>
function selectedIndexChanging(sender, evtArg)
{
    $get(gConst_hf_cur_view).value = evtArg.get_selectedIndex();
}

/// <summary>
/// when click "题横批" in step 1.
/// </summary>
/// <accessibility>private</accessibility>
function getHengpi()
{
    var newSL = GetDynamicLianString(gConst_ShangLian);
    var newXL = GetDynamicLianString(gConst_XiaLian);
    var fchanged = false;
    //if users changed shanglian or xialian set fchange to true,
    //so next time, in step 2 the DynamicAreaWithHengpi will be reconstructed.
    if( $get( g_sLastQueryShanglian ).value != newSL )
    {
        var Hengpi = $find(gConst_divHengPiResults);
        Hengpi.clear();
        $get( g_sLastQueryShanglian ).value = newSL;
        fchanged = true;
    }
    
    if( $get( g_sLastQueryXialian ).value != newXL )
    {
        var Hengpi = $find(gConst_divHengPiResults);
        Hengpi.clear();
        $get( g_sLastQueryXialian ).value = newXL;
        fchanged = true;
    }
    //if user changed xialian or shanglian in step 2, reconstruct DynamicAreaWithHengpi
    //but do not clear the original hengpi the user selected.
    if(fchanged)
    {
        AJAXGetHengPi();
    } 
}

/// <summary>
/// when user click the example xianglian in step 0, 
/// 1.fill shanglian input box
/// 2.change shanglian input box's background picture.
/// 3.change the selected indicator of the example list.
/// </summary>
/// <accessibility>private</accessibility>
function onClickExample(obj)
{
    $get(gConst_ShangLian).value = obj.lastChild.data;
    var exampleID = obj.id.slice(7);
    //change the selected indicator
    var red = document.getElementsByName("red");
    var grey = document.getElementsByName("grey");
    for(var i=0;i<red.length;i++)
    {
        red[i].style.display = gConst_display_none;
        grey[i].style.display = gConst_display_inline;
    }
    $get("pick"+exampleID).style.display = gConst_display_inline;
    $get("non-pick"+exampleID).style.display = gConst_display_none;
    changeShanglianInputBackground();
    return false;
}

/// <summary>
/// This method is to call web service to get xialian.
/// </summary>
/// <accessibility>private</accessibility>
function AJAXGetXiaLian(e)
{
    var hint = $find( gConst_div_hint );
    if(CheckLianComplete())
    {
        ShowCoupletErrorMsg(0,  $get(g_const_imgHelp),
        g_const_sErrorMsgCannotRefreshXialianCandidate, -365, 135);
        return;
    }
    
    if( CheckDynamicCellsCompleteness(gConst_ShangLian))
    {
        if($get(g_sLastQueryShanglian).value != GetDynamicLianString(gConst_ShangLian)
            || $get( g_sLastQueryXialian ).value != GetDynamicLianString(gConst_XiaLian))
        {
            onGetXiaLianRequestArguments();
            var divXiaLianView = $find( gConst_divXiaLianResults );
            divXiaLianView.set_Xialian(GetDynamicLianString(gConst_XiaLian));
            
            AJAXGetXLResult(true);
        }
        else
        {
            ShowCoupletErrorMsg(0,  $get(g_const_imgHelp),
            g_const_sErrorMsgXialianNoChange, -365, 135);
        }
    }
    else
    {
        ShowCoupletErrorMsg(0, $get(g_const_imgHelp), g_const_sErrorMsgCompleteShanglianlianFirst, -365, 135);
    }

}

/// <summary>
/// This method is to create or refresh xialian result. 
/// </summary>
/// <accessibility>private</accessibility>
/// <param name="isUpdate">indicate that generating or refreshing a new xialian </param>
function AJAXGetXLResult( isUpdate )
{
    
    var shanglian = $get( "hf_ShangLian" ).value;
    var xialian = $get( gCosnt_hf_result_xl_locker ).value;
    var context = new Utility.RequestContext(shanglian, xialian, "", isUpdate, isUpdate ? 1 : 0, 1, null);
    GetXiaLian(
        shanglian,
        xialian, 
        isUpdate,
        context);
        
    var newSL = GetDynamicLianString(gConst_ShangLian);
    var newXL = GetDynamicLianString(gConst_XiaLian);
    if( $get( g_sLastQueryShanglian ).value != newSL )
    {
        $get( g_sLastQueryShanglian ).value = newSL;
    }
    
    if( $get( g_sLastQueryXialian ).value != newXL )
    {
        $get( g_sLastQueryXialian ).value = newXL;
    }
}

/// <summary>
/// This method is to call web service to get hengpi. 
/// </summary>
/// <accessibility>private</accessibility>
function AJAXGetHengPi()
{
    onGetXiaLianRequestArguments();
    GetHengPi(
        $get( "hf_ShangLian" ).value,
        $get( gCosnt_hf_result_xl_locker ).value, 
            "");
}

/// <summary>
/// This method is to check valid of shanglian,xialian and hengpi
//  then redirect to template selecting page.. 
/// </summary>
/// <accessibility>private</accessibility>
/// <param name="hasHengpi">a flag indicates whether hengpi is needed when show couplet. </param>
function ShowCouplet(hasHengpi)
{
    var cHengpi = $find(gConst_divHengPiResults);
    var preview = $find(gConst_tbl_preview);
    if(hasHengpi)
    {
        var iErrorCode = cHengpi.isCurrentHengpiValid();
        if(0 == iErrorCode)
        {
            $get(gConst_hf_result_hp_locker).value = cHengpi.get_inputHengpi();
            var currentShanglian = GetDynamicLianString(gConst_ShangLian);
            var currentXialian = GetDynamicLianString(gConst_XiaLian);
            var currentHengpi = cHengpi.get_inputHengpi();
            redirectToShowPage(currentShanglian, currentXialian, currentHengpi);
//            var fIsForwardCheckHengpi = true;
//            var context = new Utility.RequestContext(currentShanglian, currentXialian, currentHengpi, "", 2, 3, fIsForwardCheckHengpi);
//            IsValidChineseString(currentHengpi, context);
        }
        else
        {
            switch(iErrorCode)
            {
                case -1:
                    ShowCoupletErrorMsg(0, $get(g_const_imgHelp), g_const_sErrorMsgHengpiCannotBeEmpty, -365, 165);
                    break;
                case -2:
                    ShowCoupletErrorMsg(0, $get(g_const_imgHelp), g_const_sErrorMsgHengpiLengthInvalid, -365, 165);
                    break;
                case -3:
                    ShowCoupletErrorMsg(0, $get(g_const_imgHelp), g_const_sErrorMsgInputChineseString, -365, 165);
                    break;
            }
            return;
        }
    }
    else
    {
        preview.updateDynamicHP("");
        cHengpi.set_inputHengpi("");
        $get(gConst_hf_result_hp_locker).value = "";
        cHengpi.unselectAllCandidate();
        redirectToShowPage(GetDynamicLianString(gConst_ShangLian), 
            GetDynamicLianString(gConst_XiaLian), "");
    }
    
}

/// <summary>
/// This method is to redirect to template selecting page.
/// </summary>
/// <accessibility>private</accessibility>
/// <param name="sSelectedShanglian">shanglian string. </param>
/// <param name="sSelectedXialian">xialian string. </param>
/// <param name="sSelectedHengpi">hengpi string. </param>
function redirectToShowPage(sSelectedShanglian, sSelectedXialian, sSelectedHengpi)
{
    $get( "hf_ShangLian" ).value = sSelectedShanglian;
    $get( gCosnt_hf_result_xl_locker).value = sSelectedXialian;
    var url = './RedirectPage.aspx?S=' + encodeURI(sSelectedShanglian) + '&' +
        'X=' + encodeURI(sSelectedXialian) + '&' +
        'H=' + encodeURI(sSelectedHengpi);
    window.open(url);
}

/// <summary>
/// This method is to show or hide the progress bar indicator.
/// </summary>
/// <accessibility>public</accessibility>
/// <param name="disstring">display string </param>
/// <param name="elem">element contains the waiting picture and message. </param>
/// <param name="msg">message below the waiting picture. </param>
function ShowWaitIndicator( disstring, elem, msg )
{
	var adiv = $get( elem );
	adiv.style.display = disstring;
	adiv.innerHTML ='';
	adiv.innerHTML = "<table><tr valign='middle'><td><img src='./images/wait.gif'/><br />" + msg + "</td></tr></table>";
}

/// <summary>
/// This method is to hide the hint panel when user click "确定" on the hint panel.
/// </summary>
/// <accessibility>public</accessibility>
function confirm()
{
    $get(gConst_div_hint).style.display = gConst_display_none;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//events which attach to xialian normal view componont.
// When the mouse is over the normal result table
function onNormalMouseOver( cell, args )
{
	cell.style.cursor = "pointer";
	cell.style.color = "#790000";
}

// When the mouse is out of the normal result table
function onNormalMouseOut( cell, args )
{
    cell.style.color = "Black";
}

// When user click one result within the normal result table
// We will fill the input cell with the selected result.
function onNormalClick(sender, rgArgs)
{	
    var iNewSelectId = rgArgs[0];
    var sCandidate = rgArgs[1];
    var iSegmentPatternIndex = rgArgs[2];
    $get( gConst_hf_cur_normal_select ).value = iNewSelectId;
    $get( gCosnt_hf_result_xl_locker ).value = sCandidate;
    updateDynamicLian( 0, sCandidate, gConst_XiaLian, true );
	var divXialian = $find(gConst_divXiaLianResults);
    //if seg is -1, means it does not contained in any kind of segment pattern.
    //so set it 0 defautly
    if(iSegmentPatternIndex == -1) 
    {   
        iSegmentPatternIndex = 0;
    }
    if(iSegmentPatternIndex != divXialian._adv._selectedID) 
    {
        divXialian._adv.set_segmentPatternChanged(true);

	    //if the segment pattern is changed, clear advanced view history.
	    //Warning: globlal variable.
	    $get(gConst_hf_cur_adv_select).value = "**********";
    }
    else
    {
        divXialian._adv.set_segmentPatternChanged(false);
    }
    $get( gConst_hf_curSelection ).value = iSegmentPatternIndex;
    divXialian._adv.set_selectedID(iSegmentPatternIndex);
    divXialian._adv.set_Xialian(sCandidate);
}

///////////////////////////////////////////////////////////////////////
//events which attach to xialian advanced view componont.
// When the mouse is over the normal result table
function onCandidateMouseOver( cell, args )
{
	cell.style.cursor = "pointer";
}

// When the mouse is out of the normal result table
function onCandidateMouseOut( cell, args )
{
// do nothing.
}

// When user click a word based candidate, we will fill them into the corresponding XiaLian cells.
function onCandidateClick( cell, args )
{
	if(cell.tagName == "INPUT") 
	    cell = cell.parentNode;
	var selectText = mergeCell(cell);

	// The position information is stored as a part of the id of table who contains current clicked
	// word candidate. All the candidates for a specific word is store within a table.
	var tableID = cell.attributes.getNamedItem( 'id' ).value;
	// Extract the position information from td's id. E.g. <td id='p1c4r2' ...>...</td>
	//means the first segment part, the fourth cell in the second row
	var cellID = tableID.slice(1,2);
	var iPos = tableID.slice( 3,4 );
	var row = tableID.slice(5);
	var cur_adv_select = $get( gConst_hf_cur_adv_select ).value;
	cur_adv_select = cur_adv_select.slice(0,cellID)+row.toString()+cur_adv_select.slice(parseInt(cellID)+1);
	$get( gConst_hf_cur_adv_select ).value = cur_adv_select;
	updateDynamicLian( iPos, selectText, gConst_XiaLian, false );
	$get( gCosnt_hf_result_xl_locker ).value = GetDynamicLianString(gConst_XiaLian);
	//because of the space row, there are half of the whole row count.
	for(var i = 0; i < $get("cand_tbody").childNodes.length/2; i++)
	{
	    var td = $get("cand_row"+i).childNodes[cellID];
        if(td.childNodes.length == 0 ) break;
	    for(var j = 0; j<selectText.length; j++)
        {
            td.childNodes[j].className = "advUncheck";
        }
	}

    for(var k = 0; k<selectText.length; k++)
    {
        cell.childNodes[k].className = "advCheck";
    }
}
 
//////////////////////////////////////////////////////////////////////////// 
// Events which attach to hengpi view.               
// When the mouse is over the normal result table
function onHengPiMouseOver(cell, args)
{
    cell.style.cursor = "pointer";
	cell.style.color = "#790000";
}

// When the mouse is out of the normal result table
function onHengPiMouseOut(cell, args)
{
    cell.style.color = "Black";
}

//When click HengPi candidate
function onHengPiCandidateClick(sender, rgArgs)
{   
    var iNewSelectId = rgArgs[0];
    var sCandidate = rgArgs[1];
    //change hengpi preivew box
    var preview = $find(gConst_tbl_preview);
    preview.updateDynamicHP(sCandidate);
    //change hengpi input box
    var hengpiView = $find(gConst_divHengPiResults);
    hengpiView.set_inputHengpi(sCandidate);

    $get( gConst_hf_result_hp_locker ).value = sCandidate;
    $get( gConst_hf_cur_hp_select ).value = iNewSelectId;
}

function onInputHengpiKeyup(sender, arg)
{
    var sSelectedHengpi = sender.value;
    var preview = $find(gConst_tbl_preview);
    preview.updateDynamicHP(sSelectedHengpi);
}


////////////////////////////////////////////////////////////////////////
//events which attach to select panel componont.
// When the mouse is over the select panel
function onSelectHover(cell, args)
{
    var id = cell.id.slice(2);
    var table = $get("ot" + id);
    table.style.cursor = "pointer";
    table.style.backgroundColor = "Black";
    table.style.color = "White";
}

// When the mouse is out of the select panel
function onSelectUnHover(cell, args)
{
    var id = cell.id.slice(2);
    var table = $get("ot" + id);
    var divXiaLianView = $find( gConst_divXiaLianResults );
    var selectedID = divXiaLianView._adv.get_selectedID();
    if(selectedID!=id)
    {
        table.style.backgroundColor = "White";
        table.style.color = "Black";
    }
    else
    {
        table.style.backgroundColor = "#def4d4";
        table.style.color = "Black";
    } 
}

// Handle the onChange event for segmentation selector
function onSelectChanged( sender, e )
{
	var cur_sel = parseInt(sender.id.slice(2));
	var table = $get("ot" + cur_sel);
	var divXiaLianView = $find( gConst_divXiaLianResults );
	//if user change another segment pattern, clear the advanced view history
	//and redraw the candidate list
	if( $get(gConst_hf_curSelection).value != cur_sel)
	{
	    $get( gConst_hf_cur_adv_select ).value = "**********";
	    //ShowWordCandidate( cur_sel );
	    $get( gConst_hf_curSelection ).value = cur_sel;
	}
	else
	{
	    ResetAdvSelect(true);
	}	
	table.style.backgroundColor = "#def4d4";
    table.style.color = "Black";
	$get( "divSelectionView" ).style.display = gConst_display_none;

	if (e.stopPropagation)
    {
        // FireFox
        e.stopPropagation();
    }
    else
    {
        // IE
        e.cancelBubble = true;
    }
}

//////////////////////////////////////////////////////////////////////////////////
//events which attach to shanglian and xialian inputbox componont.
//when focus on the TD which contains shanglian or xialian input box.
function onCellFocus(cell,e)
{
    if(cell.firstChild!=null)
    {
        cell.firstChild.focus();
    }
}

//when focus on shanglian or xialian input box.
// Handle the dynamic ShangLian/XiaLian input cell focus event
function onDynFocus(cell,e)
{

}

//when mouse over shanglian or xialian inputbox
function onInputMouseOver(cell, args)
{
//do nothing.
}

// Handle keydown event on ShangLian input box
function onSLDynKeyDown(cell,e)
{  
    if (!e) var e = window.event;
    if(cell!=null)
    {
        handleLianTextChange(cell);
        return filterDynamicKeyDown(cell, gConst_ShangLian, e);
    }
    else 
    {
        return null;
    }
}

// Handle keyup event on ShangLian input box
function onSLDynKeyUp(cell,e)
{
    if (!e) var e = window.event;
    if(cell!=null)
    {
        handleLianTextChange(cell);
        return filterDynamicKeyUp(cell, gConst_ShangLian, e);
    }
    else 
    {
        return null;
    }
}


// Handle keydown event on Xialian input box
function onXLDynKeyDown(cell,e)
{
    if (!e) var e = window.event;
    if(cell!=null)
    {
        handleLianTextChange(cell);
        return filterDynamicKeyDown(cell, gConst_XiaLian, e);
    }
    else 
    {
        return null;
    }
}

// Handle keyup event on ShangLian input box
function onXLDynKeyUp(cell,e)
{
    if (!e) var e = window.event;
    if(cell!=null)
    {

        handleLianTextChange(cell);
        return filterDynamicKeyUp(cell, gConst_XiaLian, e);
    }
    else 
    {
        return null;
    }  
}

//when blur from shanglian or xialian inputbox
function onDynBlur(cell,e)
{
    if(cell!=null)
    {
        var divXiaLianView = $find( gConst_divXiaLianResults );
        for( i = 0; i<cell.value.length || i == 0; i++)
        {
            var inputID = cell.id.slice(cell.id.length-1 );
            var lianEnd = cell.id.indexOf(inputID);
            // in normal view input shanglian's prefix is 'nor',
            // in advanced view input shanglian's prefix is 'seg',
            //both of them has 3 characters.            
            var lianBegin = 3;
            var lian = cell.id.slice(lianBegin,lianEnd);
            if(!checkIsChinese(cell.value.charAt( i )))
            {
                if(cell.value.length != 0)
                {
                    ShowCoupletErrorMsg(0, cell, g_const_sErrorMsgInputChineseString, -150, 20);
                }
                //delete the content of input cell
                cell.value = "";
                //delete the content of preview cell
                var preview = $find(gConst_tbl_preview);
                if(lian == gConst_ShangLian)
                {
		            preview.clear_shanglian_word(inputID);
		        }
		        else
		        {
		            preview.clear_xialian_word(inputID);
		        }
            }
            else
            {
                divXiaLianView._normal.setNormalSelectedByID(inputID,lian,cell.value.charAt( i ));
                divXiaLianView._adv.setADVSelectedByID(inputID,lian,cell.value.charAt( i ));
            }
        }
        handleLianTextChange(cell);
        //update outer record of shanglian and xialian
        $get( gCosnt_hf_result_xl_locker ).value = GetDynamicLianString(gConst_XiaLian);
	    $get( "hf_ShangLian" ).value = GetDynamicLianString(gConst_ShangLian);
	    ///update inner record of shanglian and xialian
	    
	    divXiaLianView.set_Shanglian($get( "hf_ShangLian" ).value);
	    divXiaLianView.set_Xialian($get( gCosnt_hf_result_xl_locker ).value);
    }
}

function onDynTextChange(cell,e)
{
//do nothing.
}

function onClickSurvey()
{
    var shanglian = GetDynamicLianString(gConst_ShangLian);
    var url = './Survey.aspx?S=' + encodeURI(shanglian);
    window.open(url);
}